/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain;

import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Position;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum C4Direction {
    NORTH{

        @Override
        public int stepFromColumn(int column, int stepCount) {
            return column;
        }

        @Override
        public int stepFromRow(int row, int stepCount) {
            return row - stepCount;
        }

        @Override
        public C4Direction getInverse() {
            return SOUTH;
        }
    }
    ,
    NORTH_EAST{

        @Override
        public int stepFromColumn(int column, int stepCount) {
            return column + stepCount;
        }

        @Override
        public int stepFromRow(int row, int stepCount) {
            return row - stepCount;
        }

        @Override
        public C4Direction getInverse() {
            return SOUTH_WEST;
        }
    }
    ,
    EAST{

        @Override
        public int stepFromColumn(int column, int stepCount) {
            return column + stepCount;
        }

        @Override
        public int stepFromRow(int row, int stepCount) {
            return row;
        }

        @Override
        public C4Direction getInverse() {
            return WEST;
        }
    }
    ,
    SOUTH_EAST{

        @Override
        public int stepFromColumn(int column, int stepCount) {
            return column + stepCount;
        }

        @Override
        public int stepFromRow(int row, int stepCount) {
            return row + stepCount;
        }

        @Override
        public C4Direction getInverse() {
            return NORTH_WEST;
        }
    }
    ,
    SOUTH{

        @Override
        public int stepFromColumn(int column, int stepCount) {
            return column;
        }

        @Override
        public int stepFromRow(int row, int stepCount) {
            return this.getInverse().stepFromRow(row, -stepCount);
        }

        @Override
        public C4Direction getInverse() {
            return NORTH;
        }
    }
    ,
    SOUTH_WEST{

        @Override
        public int stepFromColumn(int column, int stepCount) {
            return this.getInverse().stepFromColumn(column, -stepCount);
        }

        @Override
        public int stepFromRow(int row, int stepCount) {
            return this.getInverse().stepFromRow(row, -stepCount);
        }

        @Override
        public C4Direction getInverse() {
            return NORTH_EAST;
        }
    }
    ,
    WEST{

        @Override
        public int stepFromColumn(int column, int stepCount) {
            return this.getInverse().stepFromColumn(column, -stepCount);
        }

        @Override
        public int stepFromRow(int row, int stepCount) {
            return row;
        }

        @Override
        public C4Direction getInverse() {
            return EAST;
        }
    }
    ,
    NORTH_WEST{

        @Override
        public int stepFromColumn(int column, int stepCount) {
            return this.getInverse().stepFromColumn(column, -stepCount);
        }

        @Override
        public int stepFromRow(int row, int stepCount) {
            return this.getInverse().stepFromRow(row, -stepCount);
        }

        @Override
        public C4Direction getInverse() {
            return SOUTH_EAST;
        }
    };


    public abstract int stepFromColumn(int var1, int var2);

    public abstract int stepFromRow(int var1, int var2);

    public IC4Position stepFrom(IC4Position position, int stepCount) {
        int resultRow = this.stepFromRow(position.getRow(), stepCount);
        int resultColumn = this.stepFromColumn(position.getColumn(), stepCount);
        return new C4Position(resultRow, resultColumn);
    }

    public abstract C4Direction getInverse();
}

