/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl;

import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.AnswerOptions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FzgPlayerImpl
extends AbstractPlayer<FzgPlayer>
implements FzgPlayer {
    private Optional<AnswerOptions> answer;
    private final Map<AnswerOptions, Map<AnswerOptions, Double>> possibleOutcomes;

    protected FzgPlayerImpl(String name, Map<AnswerOptions, Map<AnswerOptions, Double>> possibleOutcomes) {
        super(name);
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<AnswerOptions, Map<AnswerOptions, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
        this.answer = Optional.empty();
    }

    public FzgPlayerImpl(FzgPlayer source) {
        super((Player)source);
        this.possibleOutcomes = source.getPossibleOutcomes();
        this.answer = source.getAnswer();
    }

    public String toString() {
        return String.format("FzgPlayer[name=%s, state=%s, outcome=%s, answer=%s]", this.getName(), this.getState(), this.getOutcome(), this.answer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FzgPlayerImpl) {
            FzgPlayerImpl other = (FzgPlayerImpl)obj;
            return super.equals(obj) && this.answer.equals(other.answer) && this.possibleOutcomes.equals(other.possibleOutcomes);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ Objects.hash(this.answer, this.possibleOutcomes);
    }

    public FzgPlayer deepCopy() {
        return new FzgPlayerImpl(this);
    }

    @Override
    public void setAnswer(AnswerOptions value) {
        if (this.answer.isPresent()) {
            throw new IllegalStateException(String.format("Player %s tried to change her answer.", this.getName()));
        }
        this.answer = Optional.of(value);
    }

    @Override
    public Map<AnswerOptions, Map<AnswerOptions, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public Optional<AnswerOptions> getAnswer() {
        return this.answer;
    }
}

