/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.reactive;

import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundPlayerData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;
import java.util.Optional;
import java.util.Random;

public class DilemmaReactiveStrategy
extends DilemmaMemoryStrategy {
    static final double COOPERATION_FIRST_ROUND_PROB = 0.5;
    static final double COOPERATION_AFTER_COOPERATION_PROB = 0.8;
    static final double COOPERATION_AFTER_DEFECT_PROB = 0.2;
    private static final Random RANDOM = new Random();

    DilemmaReactiveStrategy(IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    public Optional<IDilemmaMove> computeNextMove(int gameId, IDilemmaPlayer player, IDilemmaState state) {
        IGameMemory<DilemmaRoundData> memory = this.getMemoryForPlayer(player, state);
        IDilemmaMoveFactory moveFactory = this.getMoveFactory();
        if (memory.size() == 0) {
            if (RANDOM.nextDouble() < 0.5) {
                return Optional.of(moveFactory.createCooperateMove());
            }
            return Optional.of(moveFactory.createDefectMove());
        }
        DilemmaRoundData previousRound = (DilemmaRoundData)memory.getRound(0, true);
        DilemmaRoundPlayerData otherPlayersAction = previousRound.forOpponentOf(player);
        if (otherPlayersAction.answer().equals((Object)DilemmaAnswerType.COOPERATE)) {
            if (RANDOM.nextDouble() < 0.8) {
                return Optional.of(moveFactory.createCooperateMove());
            }
            return Optional.of(moveFactory.createDefectMove());
        }
        if (RANDOM.nextDouble() < 0.2) {
            return Optional.of(moveFactory.createCooperateMove());
        }
        return Optional.of(moveFactory.createDefectMove());
    }

    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.unlimited();
    }
}

