/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel23-tictactoe-gui.
 *
 * ipspiel23-tictactoe-gui is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * ipspiel23-tictactoe-gui is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * ipspiel23-tictactoe-gui. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel23.tictactoe.gui.event;

import de.fhdw.gaming.ipspiel23.tictactoe.core.domain.TicTacToePosition;

/**
 * Represents an {@link TicTacToeBoardEvent} where the user selected a field to make a move.
 */
public final class TicTacToeMakeMoveBoardEvent implements TicTacToeBoardEvent {

    /**
     * The position of the field selected.
     */
    private final TicTacToePosition fieldPosition;

    /**
     * Constructor.
     *
     * @param fieldPosition The position of the field selected.
     */
    public TicTacToeMakeMoveBoardEvent(final TicTacToePosition fieldPosition) {
        this.fieldPosition = fieldPosition;
    }

    /**
     * Returns the position of the field selected.
     */
    public TicTacToePosition getFieldPosition() {
        return this.fieldPosition;
    }

    @Override
    public void accept(final TicTacToeBoardEventVisitor visitor) {
        visitor.handleMakeMove(this);
    }
}
