package de.fhdw.gaming.ipspiel23.dilemma.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A Factory {@link GameBuilderFactory} which allows to create a Dilemma game builder.
 */
public interface IDilemmaGameBuilderFactory extends GameBuilderFactory {

    /**
     * Player's outcome on cooperate/cooperate.
     */
    String PARAM_OUTCOME_ON_COOPERATE_COOPERATE = "playerOutcomeOnCooperateCooperate";

    /**
     * Player's outcome on cooperate/defect.
     */
    String PARAM_OUTCOME_ON_COOPERATE_DEFECT = "playerOutcomeOnCooperateDefect";

    /**
     * Player's outcome on defect/cooperate.
     */
    String PARAM_OUTCOME_ON_DEFECT_COOPERATE = "playerOutcomeOnDefectCooperate";

    /**
     * Player's outcome on defect/defect.
     */
    String PARAM_OUTCOME_ON_DEFECT_DEFECT = "playerOutcomeOnDefectDefect";

    @Override
    IDilemmaGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
