/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.domain.internals;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaGame;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaGameBuilder;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayerBuilder;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.domain.internals.DilemmaGame;
import de.fhdw.gaming.ipspiel23.dilemma.domain.internals.DilemmaPlayerBuilder;
import de.fhdw.gaming.ipspiel23.dilemma.domain.internals.DilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.internals.DilemmaMove;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DilemmaGameBuilder
implements IDilemmaGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider;
    private final List<IDilemmaPlayer> players = new ArrayList<IDilemmaPlayer>(2);
    private final Map<String, DilemmaPlayerBuilder> playerBuilders = new HashMap<String, DilemmaPlayerBuilder>();
    private int maxComputationTimePerMove = 5;

    public DilemmaGameBuilder() {
        this.observerFactoryProvider = new DefaultObserverFactoryProvider();
    }

    @Override
    public IDilemmaPlayerBuilder createPlayerBuilder() {
        return new DilemmaPlayerBuilder(this);
    }

    void onPlayerBuilt(DilemmaPlayerBuilder builder, IDilemmaPlayer player) {
        this.playerBuilders.put(player.getName(), builder);
    }

    @Override
    public IDilemmaGameBuilder addPlayer(IDilemmaPlayer player, IDilemmaStrategy strategy) throws GameException {
        if (this.players.size() >= 2) {
            throw new GameException(String.format("More than two players are not allowed.", new Object[0]));
        }
        DilemmaPlayerBuilder builder = this.playerBuilders.getOrDefault(player.getName(), null);
        if (builder == null) {
            throw new GameException("Attempted to add player that was not built using a " + DilemmaPlayerBuilder.class.getSimpleName());
        }
        builder.injectPlayerStrategyUsingHook(player, strategy);
        this.players.add(player);
        return this;
    }

    @Override
    public IDilemmaGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public IDilemmaGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public IDilemmaGame build(int id) throws GameException, InterruptedException {
        if (this.players.size() != 2) {
            throw new GameException("A Dilemma game needs exactly two players.");
        }
        DilemmaState initialState = new DilemmaState(this.players.get(0), this.players.get(1));
        Map<String, IDilemmaStrategy> strategies = this.players.stream().collect(Collectors.toMap(p -> p.getName(), p -> p.getStrategy()));
        return new DilemmaGame(id, initialState, strategies, this.maxComputationTimePerMove, DilemmaMove.class::isInstance, this.observerFactoryProvider);
    }
}

