package de.fhdw.gaming.ipspiel23.c4.strategies.internals;

import de.fhdw.gaming.ipspiel23.c4.moves.factory.IC4MoveFactory;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4Strategy;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4StrategyFactory;

/**
 * The factory for creating {@link C4RandomMoveStrategy} instances.
 */
public class C4RandomMoveStrategyFactory implements IC4StrategyFactory {

    @Override
    public IC4Strategy create(final IC4MoveFactory moveFactory) {
        return new C4RandomMoveStrategy(moveFactory);
    }
}
