/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.domain.internals;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.internals.DilemmaDefaultMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryIdentifier;
import de.fhdw.gaming.ipspiel23.memory.MemoryState;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class DilemmaState
extends MemoryState<IDilemmaPlayer, IDilemmaState, DilemmaRoundData>
implements IDilemmaState {
    private final IDilemmaPlayer firstPlayer;
    private final IDilemmaPlayer secondPlayer;

    public DilemmaState(IDilemmaPlayer firstPlayer, IDilemmaPlayer secondPlayer) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayer, "firstPlayer");
        this.secondPlayer = Objects.requireNonNull(secondPlayer, "secondPlayer");
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    DilemmaState(DilemmaState source) {
        this.firstPlayer = source.firstPlayer.deepCopy();
        this.secondPlayer = source.secondPlayer.deepCopy();
    }

    @Override
    public IDilemmaPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public IDilemmaPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("DilemmaState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DilemmaState) {
            DilemmaState other = (DilemmaState)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public IDilemmaState deepCopy() {
        return new DilemmaState(this);
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public Map<String, IDilemmaPlayer> getPlayers() {
        LinkedHashMap<String, IDilemmaPlayer> result = new LinkedHashMap<String, IDilemmaPlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public Set<IDilemmaPlayer> computeNextPlayers() {
        LinkedHashSet<IDilemmaPlayer> playersWithoutMove = new LinkedHashSet<IDilemmaPlayer>();
        if (this.firstPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.firstPlayer);
        }
        if (this.secondPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.secondPlayer);
        }
        return playersWithoutMove;
    }

    @Override
    public IDilemmaPlayer getOpponentOf(IDilemmaPlayer player) {
        if (this.firstPlayer.getName().equals(player.getName())) {
            return this.secondPlayer;
        }
        if (this.secondPlayer.getName().equals(player.getName())) {
            return this.firstPlayer;
        }
        throw new IllegalArgumentException("Unknown player: " + player);
    }

    public void nextTurn() {
        Set<IDilemmaPlayer> playersWithoutMove = this.computeNextPlayers();
        if (playersWithoutMove.isEmpty()) {
            DilemmaAnswerType answerOfFirstPlayer = this.firstPlayer.getAnswer().orElseThrow();
            DilemmaAnswerType answerOfSecondPlayer = this.secondPlayer.getAnswer().orElseThrow();
            Double outcomeOfFirstPlayer = this.firstPlayer.getPossibleOutcomes().get((Object)answerOfFirstPlayer).get((Object)answerOfSecondPlayer);
            this.firstPlayer.setState(DilemmaState.outcomeToState(outcomeOfFirstPlayer));
            this.firstPlayer.setOutcome(outcomeOfFirstPlayer);
            Double outcomeOfSecondPlayer = this.secondPlayer.getPossibleOutcomes().get((Object)answerOfSecondPlayer).get((Object)answerOfFirstPlayer);
            this.secondPlayer.setState(DilemmaState.outcomeToState(outcomeOfSecondPlayer));
            this.secondPlayer.setOutcome(outcomeOfSecondPlayer);
            DilemmaDefaultMoveFactory moveFactory = new DilemmaDefaultMoveFactory();
            IDilemmaMove player1Move = moveFactory.fromAnswer(answerOfFirstPlayer);
            IDilemmaMove player2Move = moveFactory.fromAnswer(answerOfSecondPlayer);
            DilemmaRoundData round = DilemmaRoundData.fromRaw(this.firstPlayer, player1Move, this.secondPlayer, player2Move);
            this.storeRoundData(GameMemoryIdentifier.of((Player)this.firstPlayer, (Strategy)this.firstPlayer.getStrategy(), (Strategy)this.secondPlayer.getStrategy()), round);
            this.storeRoundData(GameMemoryIdentifier.of((Player)this.secondPlayer, (Strategy)this.secondPlayer.getStrategy(), (Strategy)this.firstPlayer.getStrategy()), round);
        }
    }

    private static PlayerState outcomeToState(Double outcome) {
        double[] predefinedOutcomes = new double[]{-1.0, -10.0, 0.0, -8.0};
        PlayerState[] states = new PlayerState[]{PlayerState.WON, PlayerState.LOST, PlayerState.WON, PlayerState.LOST};
        for (int i = 0; i < states.length; ++i) {
            if (!DilemmaState.isWithinDelta(outcome, predefinedOutcomes[i], 0.01)) continue;
            return states[i];
        }
        throw new IllegalStateException("Unable to map unknown outcome to player state :C");
    }

    private static boolean isWithinDelta(double value, double comparand, double delta) {
        return Math.abs(value - comparand) < delta;
    }
}

