/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.domain.internals;

import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.domain.internals.DilemmaPlayerBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DilemmaPlayer
extends AbstractPlayer<IDilemmaPlayer>
implements IDilemmaPlayer {
    private Optional<DilemmaAnswerType> answer;
    private IDilemmaStrategy strategy;
    private final Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> possibleOutcomes;

    DilemmaPlayer(DilemmaPlayerBuilder builder, String name, Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> possibleOutcomes) {
        super(name);
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<DilemmaAnswerType, Map<DilemmaAnswerType, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
        this.answer = Optional.empty();
        builder.registerPlayerStrategyHook(this, newStrategy -> {
            this.strategy = newStrategy;
        });
    }

    DilemmaPlayer(IDilemmaPlayer source) {
        super((Player)source);
        this.possibleOutcomes = source.getPossibleOutcomes();
        this.answer = source.getAnswer();
        this.strategy = source.getStrategy();
    }

    public boolean equals(Object object) {
        if (object instanceof DilemmaPlayer) {
            DilemmaPlayer other = (DilemmaPlayer)object;
            return super.equals(object) && this.answer.equals(other.answer) && this.possibleOutcomes.equals(other.possibleOutcomes);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.answer, this.possibleOutcomes);
    }

    @Override
    public Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public Optional<DilemmaAnswerType> getAnswer() {
        return this.answer;
    }

    @Override
    public void setAnswer(DilemmaAnswerType newAnswer) {
        if (this.answer.isPresent()) {
            throw new IllegalStateException(String.format("Player %s tried to change her answer.", this.getName()));
        }
        this.answer = Optional.of(newAnswer);
    }

    @Override
    public IDilemmaPlayer deepCopy() {
        return new DilemmaPlayer(this);
    }

    public String toString() {
        return String.format("DilemmaPlayer[name=%s, state=%s, outcome=%s, answer=%s]", this.getName(), this.getState(), this.getOutcome(), this.answer);
    }

    @Override
    public IDilemmaStrategy getStrategy() {
        if (this.strategy == null) {
            throw new IllegalStateException("The strategy of player " + this.getName() + " was never set.");
        }
        return this.strategy;
    }
}

