/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel23-tictactoe-gui.
 *
 * ipspiel23-tictactoe-gui is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * ipspiel23-tictactoe-gui is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * ipspiel23-tictactoe-gui. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel23.tictactoe.gui.impl;

import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.gui.GuiObserverFactory;

/**
 * Implements {@link GuiObserverFactory} by creating a Tic Tac Toe GUI observer factory.
 */
public final class TicTacToeGuiObserverFactoryImpl implements GuiObserverFactory {

    @Override
    public GuiObserver createObserver() {
        return new TicTacToeGuiObserverImpl();
    }
}
