package de.fhdw.gaming.ipspiel23.c4.gststrategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import de.fhdw.gaming.ipspiel23.c4.moves.factory.IC4MoveFactory;
import de.fhdw.gaming.ipspiel23.gst.domain.IKopplung;

/**
 * The C4-GST-Kopplung.
 */
public class C4GSTKopplung implements IKopplung<IC4Player, IC4State> {

    
    /**
     * TODO: Strategy-Pattern
     */
    private SimpleC4GSTEvaluation evaluationStrategy;
    
    
    
    /**
     * The Movefactory.
     */
    private IC4MoveFactory moveFactory;

    /**
     * Ctr.
     * @param moveFactory
     */
    public C4GSTKopplung(IC4MoveFactory moveFactory) {
        this.moveFactory = moveFactory;
        this.evaluationStrategy = new SimpleC4GSTEvaluation();
    }

    @Override
    public Optional<Collection<Move<IC4Player, IC4State>>> getPossibleMoves(IC4State state) {

        // seems to work as intended
        final IC4Position[] positions = state.getBoard().getLegalPositions();

        final Collection<Move<IC4Player, IC4State>> possibleMoves = new ArrayList<>();

        for (IC4Position position : positions) {
            possibleMoves.add(moveFactory.createMove(state.getCurrentPlayer(), position));
        }

        //
        return Optional.of(possibleMoves);
    }

    @Override
    public Optional<Integer> evalState(IC4State state) {
       return Optional.of(evaluationStrategy.evalC4State(state));
    }

    @Override
    public Optional<IC4Player> getCurrentPlayer(IC4State state) {
      return Optional.of(state.getCurrentPlayer());
    }

    @Override
    public Optional<Boolean> getIsGameOver(IC4State state) {
        
        return Optional.of(state.getPlayers().values().stream()
                .filter(p -> p.getState() == PlayerState.PLAYING)
                .findAny()
                .isEmpty()
                );
        
        //return Optional.of(false);
        
        
        //return Optional.of(state.getPlayers().values()
        //        .stream()
        //        .filter(p -> p.getOutcome().get() > 0)
        //        .count() > 0);
        
        

    }

}
