package de.fhdw.gaming.ipspiel23.c4.gui;

import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import de.fhdw.gaming.ipspiel23.c4.gui.event.C4BoardEvent;

/**
 * Provides input from the user interacting with a C4 board.
 */
public interface C4BoardEventProvider {
    
    /**
     * Waits for a user event and returns it.
     *
     * @param player It is this player's turn.
     * @param state  A copy of the game state.
     * @return The {@link C4BoardEvent} generated by the user.
     */
    C4BoardEvent waitForEvent(IC4Player player, IC4State state);

    /**
     * If the provider is currently waiting for a user event, the wait operation will be cancelled.
     */
    void cancelWaiting();
}  
