/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Board;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Field;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import java.util.Optional;

public class C4FieldHeavy
implements IC4Field {
    private final IC4Board board;
    private final IC4Position position;
    private Optional<IC4Player> occupyingPlayer;

    public C4FieldHeavy(IC4Board board, IC4Position position) {
        this.board = board;
        this.position = position;
        this.occupyingPlayer = Optional.empty();
    }

    @Override
    public IC4Board getBoard() {
        return this.board;
    }

    @Override
    public IC4Position getBoardPosition() {
        return this.position;
    }

    @Override
    public Optional<IC4Player> getOccupyingPlayer() {
        return this.occupyingPlayer;
    }

    @Override
    public boolean trySetOccupyingPlayer(IC4Player player, boolean allowOverride) {
        if (this.occupyingPlayer.isPresent() && !allowOverride) {
            return false;
        }
        this.occupyingPlayer = Optional.ofNullable(player);
        return true;
    }

    @Override
    public boolean hasNeighbor(C4Direction direction) {
        IC4Position neighborPosition = direction.stepFrom(this.getBoardPosition(), 1);
        return this.getBoard().checkBounds(neighborPosition);
    }

    @Override
    public IC4Field getNeighbor(C4Direction direction) {
        return this.getNeighborInternal(direction, true);
    }

    @Override
    public Optional<IC4Field> tryGetNeighbor(C4Direction direction) {
        IC4Field neighbor = this.getNeighborInternal(direction, false);
        return Optional.ofNullable(neighbor);
    }

    private IC4Field getNeighborInternal(C4Direction direction, boolean throwOob) {
        IC4Position neighborPosition = direction.stepFrom(this.getBoardPosition(), 1);
        if (!this.getBoard().checkBounds(neighborPosition)) {
            if (throwOob) {
                throw new IndexOutOfBoundsException("The provided direction violates the bounds of the game board.");
            }
            return null;
        }
        return this.getBoard().tryGetField(neighborPosition).orElseThrow();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IC4Field)) {
            return false;
        }
        IC4Field other = (IC4Field)obj;
        return this.getBoardPosition().equals(other.getBoardPosition()) && this.getBoard().equals(other.getBoard());
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.getBoardPosition().hashCode();
        hash = hash * 31 + this.getBoard().hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("C4FieldHeavy[player=").append(this.getOccupyingPlayer().map(Player::getName).orElse("empty")).append(", position=").append(this.getBoardPosition()).append(']');
        return sb.toString();
    }

    @Override
    public IC4Field deepCopy() {
        return new C4FieldHeavy(this.board, this.position);
    }
}

