/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Field;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Solution;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4SolutionSlim;
import java.util.Arrays;

public class C4SolutionHeavy
implements IC4Solution {
    private final IC4Player owner;
    private final IC4Position startPosition;
    private final IC4Position endPosition;
    private final C4Direction direction;
    private final IC4Field[] containingFields;

    public C4SolutionHeavy(IC4Player owner, IC4Position startPosition, IC4Position endPosition, C4Direction direction, IC4Field ... containingFields) {
        this.owner = owner;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.direction = direction;
        this.containingFields = Arrays.copyOf(containingFields, containingFields.length);
    }

    @Override
    public IC4Player getOwner() {
        return this.owner;
    }

    @Override
    public IC4Position getStartPosition() {
        return this.startPosition;
    }

    @Override
    public IC4Position getEndPosition() {
        return this.endPosition;
    }

    @Override
    public C4Direction getDirection() {
        return this.direction;
    }

    @Override
    public int size() {
        return this.containingFields.length;
    }

    @Override
    public IC4Field[] getContainingFields() {
        return Arrays.copyOf(this.containingFields, this.containingFields.length);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof IC4SolutionSlim)) {
            return false;
        }
        IC4SolutionSlim otherSolution = (IC4SolutionSlim)other;
        return this.getOwner().equals(otherSolution.getOwner()) && (this.getStartPosition().equals(otherSolution.getStartPosition()) && this.getEndPosition().equals(otherSolution.getEndPosition()) || this.getStartPosition().equals(otherSolution.getEndPosition()) && this.getEndPosition().equals(otherSolution.getStartPosition())) && this.size() == otherSolution.size();
    }

    public int hashCode() {
        int hash = 217;
        hash += this.getOwner().hashCode();
        hash = hash * 31 + (this.getStartPosition().hashCode() ^ this.getEndPosition().hashCode());
        hash = hash * 31 + this.size();
        return hash;
    }

    public String toString() {
        return String.format("C4SolutionSlim: (%d, %d) -- %d -- (%d, %d)", this.getStartPosition().getRow(), this.getStartPosition().getColumn(), this.getOwner().getToken(), this.getEndPosition().getRow(), this.getEndPosition().getColumn());
    }
}

