/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.moves.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Field;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Position;
import de.fhdw.gaming.ipspiel23.c4.moves.IC4Move;

final class C4Move
implements IC4Move {
    private final IC4Player localPlayer;
    private final int row;
    private final int column;
    private IC4Position position;

    C4Move(IC4Player player, int rowIndex, int columnIndex) {
        this.localPlayer = player;
        this.row = rowIndex;
        this.column = columnIndex;
    }

    C4Move(IC4Player player, IC4Position position) {
        this(player, position.getRow(), position.getColumn());
        this.position = position;
    }

    IC4Player getPlayer() {
        return this.localPlayer;
    }

    @Override
    public IC4Position getTargetPosition() {
        if (this.position == null) {
            this.position = new C4Position(this.row, this.column);
        }
        return this.position;
    }

    public void applyTo(IC4State state, IC4Player player) throws GameException {
        if (player.getToken() != this.localPlayer.getToken()) {
            throw new IllegalStateException(String.format("The specified player '%s' cannot perform move '%s', which was reserved for '%s'", player, this.localPlayer, this.toString()));
        }
        IC4Field field = state.getBoard().getField(this.getTargetPosition());
        boolean success = field.trySetOccupyingPlayer(player, false);
        if (!success) {
            throw new GameException(String.format("The requested move '%s' could not be performed. Did you attempt to place a token in the air? Was the target position already occupied?", this.toString()));
        }
        state.onMoveCompleted();
    }

    public String toString() {
        return String.format("Insert token at (%s,%s)", this.column, this.row);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IC4Move)) {
            return false;
        }
        IC4Move other = (IC4Move)obj;
        return this.getTargetPosition().equals(other.getTargetPosition());
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.row;
        hash = hash * 31 + this.column;
        hash = hash * 31 + this.localPlayer.getToken();
        return hash;
    }
}

