/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Position;

public class C4SolutionSlim
implements IC4SolutionSlim {
    private final int token;
    private final int rowIndexStart;
    private final int columnIndexStart;
    private final int rowIndexEnd;
    private final int columnIndexEnd;
    private final C4BoardSlim parentBoard;
    private final C4Direction direction;
    private final int solutionSize;
    private IC4Position startPosition;
    private IC4Position endPosition;

    public C4SolutionSlim(C4BoardSlim parentBoard, int token, int rowIndexEnd, int columnIndexEnd, C4Direction direction, int solutionSize) {
        this.parentBoard = parentBoard;
        this.solutionSize = solutionSize;
        this.token = token;
        this.rowIndexEnd = rowIndexEnd;
        this.columnIndexEnd = columnIndexEnd;
        this.direction = direction;
        C4Direction inverseDirection = direction.getInverse();
        int steps = solutionSize - 1;
        this.rowIndexStart = inverseDirection.stepFromRow(rowIndexEnd, steps);
        this.columnIndexStart = inverseDirection.stepFromColumn(columnIndexEnd, steps);
    }

    public int getColumnIndexEnd() {
        return this.columnIndexEnd;
    }

    public int getRowIndexEnd() {
        return this.rowIndexEnd;
    }

    @Override
    public IC4Player getOwner() {
        return this.parentBoard.getPlayerByToken(this.token);
    }

    @Override
    public IC4Position getStartPosition() {
        if (this.startPosition == null) {
            this.startPosition = new C4Position(this.rowIndexStart, this.columnIndexStart);
        }
        return this.startPosition;
    }

    @Override
    public IC4Position getEndPosition() {
        if (this.endPosition == null) {
            this.endPosition = new C4Position(this.rowIndexEnd, this.columnIndexEnd);
        }
        return this.endPosition;
    }

    @Override
    public int size() {
        return this.solutionSize;
    }

    @Override
    public C4Direction getDirection() {
        return this.direction;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof IC4SolutionSlim)) {
            return false;
        }
        IC4SolutionSlim otherSolution = (IC4SolutionSlim)other;
        return this.token == otherSolution.getOwner().getToken() && (this.getStartPosition().equals(otherSolution.getStartPosition()) && this.getEndPosition().equals(otherSolution.getEndPosition()) || this.getStartPosition().equals(otherSolution.getEndPosition()) && this.getEndPosition().equals(otherSolution.getStartPosition())) && this.size() == otherSolution.size();
    }

    public int hashCode() {
        int hash = 217;
        hash += this.token;
        hash = hash * 31 + (this.getStartPosition().hashCode() ^ this.getEndPosition().hashCode());
        hash = hash * 31 + this.size();
        return hash;
    }

    public String toString() {
        return String.format("C4SolutionSlim: (%d, %d) -- %d -- (%d, %d)", this.rowIndexStart, this.columnIndexStart, this.token, this.rowIndexEnd, this.columnIndexEnd);
    }
}

