/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation;

import de.fhdw.gaming.ipspiel23.c4.domain.IC4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation.C4SolutionAnalyzer;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation.C4SolutionAnalyzerDiagonalLeft;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation.C4SolutionAnalyzerDiagonalRight;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation.C4SolutionAnalyzerHorizontal;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation.C4SolutionAnalyzerVertical;
import java.util.HashSet;
import java.util.Set;

public class C4SolutionEvaluator {
    private final C4SolutionAnalyzer[] directionEvaluators;

    public C4SolutionEvaluator(C4BoardSlim board) {
        this.directionEvaluators = new C4SolutionAnalyzer[]{new C4SolutionAnalyzerHorizontal(board), new C4SolutionAnalyzerVertical(board), new C4SolutionAnalyzerDiagonalRight(board), new C4SolutionAnalyzerDiagonalLeft(board)};
    }

    public void resetAnalyzerCaches() {
        for (C4SolutionAnalyzer analyzer : this.directionEvaluators) {
            analyzer.resetCache();
        }
    }

    public IC4SolutionSlim tryFindFirstSolution(boolean updateCache) {
        IC4SolutionSlim solution = null;
        for (C4SolutionAnalyzer analyzer : this.directionEvaluators) {
            solution = analyzer.tryFindFirstSolution(solution, updateCache);
        }
        return solution;
    }

    public Set<IC4SolutionSlim> findAllSolutions(boolean updateCache) {
        HashSet<IC4SolutionSlim> solutions = new HashSet<IC4SolutionSlim>();
        for (C4SolutionAnalyzer analyzer : this.directionEvaluators) {
            analyzer.findAllSolutions(solutions, updateCache);
        }
        return solutions;
    }
}

