/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel23.c4.collections.IReadOnlyDictionary;
import de.fhdw.gaming.ipspiel23.c4.collections.ReadOnlyDictionary;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Game;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4GameBuilder;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4PlayerBuilder;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Board;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Game;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4PlayerBuilder;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4State;
import de.fhdw.gaming.ipspiel23.c4.moves.IC4Move;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4Strategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class C4GameBuilder
implements IC4GameBuilder {
    private ObserverFactoryProvider observerFactoryProvider;
    private int maxComputationTimePerMove = 5;
    private int rowCount = 6;
    private int columnCount = 7;
    private int solutionSize = 4;
    private final AtomicInteger currentPlayerId;
    private final List<IC4Player> players = new ArrayList<IC4Player>(2);
    private final Map<Integer, C4PlayerBuilder> playerBuilders;

    public C4GameBuilder() {
        this.currentPlayerId = new AtomicInteger(0);
        this.playerBuilders = new HashMap<Integer, C4PlayerBuilder>(2);
        this.observerFactoryProvider = new DefaultObserverFactoryProvider();
    }

    public C4GameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        if (newMaxComputationTimePerMove <= 0) {
            throw new IllegalArgumentException("The computation time must be positive.");
        }
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public IC4PlayerBuilder createPlayerBuilder() {
        int playerId = this.currentPlayerId.incrementAndGet();
        C4PlayerBuilder builder = new C4PlayerBuilder(playerId);
        this.playerBuilders.put(playerId, builder);
        return builder;
    }

    @Override
    public IC4GameBuilder addPlayer(IC4Player player, IC4Strategy strategy) throws GameException {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(strategy, "strategy");
        C4PlayerBuilder builder = this.playerBuilders.get(player.getToken());
        if (builder == null) {
            throw new GameException(String.format("Encountered player %s with invalid or expired token: %s", player, player.getToken()));
        }
        for (IC4Player p : this.players) {
            if (!player.getName().equalsIgnoreCase(p.getName())) continue;
            throw new GameException(String.format("Tried to add two players with identical name: %s", player.getName()));
        }
        builder.injectPlayerStrategyUsingHook(strategy);
        this.playerBuilders.remove(player.getToken());
        this.players.add(player);
        return this;
    }

    @Override
    public IC4GameBuilder changeBoardRows(int newRowCount) {
        this.rowCount = newRowCount;
        return this;
    }

    @Override
    public IC4GameBuilder changeBoardColumns(int newColumnCount) {
        this.columnCount = newColumnCount;
        return this;
    }

    @Override
    public IC4GameBuilder changeRequiredSolutionSize(int newSolutionSize) {
        this.solutionSize = newSolutionSize;
        return this;
    }

    @Override
    public IC4GameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public IC4Game build(int id) throws GameException, InterruptedException {
        if (this.players.isEmpty()) {
            throw new GameException("A Connect Four game needs players to..., you know..., qualify as a game :P");
        }
        Collections.sort(this.players, (p1, p2) -> p1.getToken() - p2.getToken());
        IC4Player[] playerArr = new IC4Player[this.players.size()];
        this.players.toArray(playerArr);
        HashMap<Integer, IC4Player> playerTokenLut = new HashMap<Integer, IC4Player>(playerArr.length);
        HashMap<String, IC4Strategy> strategyLut = new HashMap<String, IC4Strategy>(playerArr.length);
        for (int i = 0; i < playerArr.length; ++i) {
            IC4Player player = playerArr[i];
            if (player.getToken() != i + 1) {
                throw new IllegalStateException(String.format("The 'players' must be ordered ascending by tokens, starting at token 1 and incrementing by 1 for each following player!. Player %s at index %s violates this rule!", player, i));
            }
            playerTokenLut.put(player.getToken(), player);
            strategyLut.put(player.getName(), player.getStrategy());
        }
        IReadOnlyDictionary<Integer, IC4Player> roPlayerTokenLut = ReadOnlyDictionary.of(playerTokenLut);
        C4BoardSlim slimBoard = new C4BoardSlim(roPlayerTokenLut, this.rowCount, this.columnCount, this.solutionSize);
        C4Board board = new C4Board(slimBoard);
        C4State initialState = new C4State(playerArr, board);
        return new C4Game(id, initialState, strategyLut, this.maxComputationTimePerMove, IC4Move.class::isInstance, this.observerFactoryProvider);
    }
}

