package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import java.util.Optional;

import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.core.domain.PlayerState;

/**
 * The mutable state of a player.
 */
class C4MutablePlayerState {
    /**
     * The current state of the player.
     */
    private PlayerState state;

    /**
     * The outcome of the player.
     */
    private Double outcome;

    /**
     * Creates a new instance of {@link C4MutablePlayerState}.
     * 
     * @param state The current state of the player.
     * @param outcome The outcome of the player.
     */
    public C4MutablePlayerState(final PlayerState state, final Double outcome) {
        this.state = state;
        this.outcome = outcome;
    }

    /**
     * Gets the current state of the player.
     */
    public PlayerState getState() {
        return state;
    }

    /**
     * Sets the current state of the player.
     * @param state the new state
     */
    public void setState(final PlayerState state) {
        this.state = state;
    }

    /**
     * Gets the outcome of the player.
     */
    public Optional<Double> getOutcome() {
        if (outcome != null) {
            return Optional.of(outcome);
        }
        return AbstractPlayer.mapStateToOutcome(state);
    }

    /**
     * Sets the outcome of the player.
     * @param outcome the new outcome
     */
    public void setOutcome(final Double outcome) {
        this.outcome = outcome;
    }
    
    @Override
    public String toString() {
        final StringBuilder bob = new StringBuilder(64);
        bob.append("C4MutablePlayerState [state=").append(this.state)
            .append(", outcome=").append(this.getOutcome()).append(']');
        return bob.toString();
    }
    
    @Override
    public boolean equals(final Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof C4MutablePlayerState)) {
            return false;
        }
        final C4MutablePlayerState other = (C4MutablePlayerState) object;
        if (this.state != other.state) {
            return false;
        }
        return this.outcome == null && other.outcome == null
            || this.outcome != null && this.outcome.equals(other.outcome);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.outcome != null) {
            hash = 31 * hash + this.outcome.hashCode();
        }
        hash = 31 * hash + this.state.hashCode();
        return hash;
    }
}
