/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Board;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Solution;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class C4State
implements IC4State {
    private final IC4Board board;
    private final IC4Player[] players;
    private int currentPlayerIndex;
    private Map<String, IC4Player> playerMap;

    public C4State(IC4Player[] players, IC4Board board) {
        this.board = Objects.requireNonNull(board, "board");
        this.players = Objects.requireNonNull(players, "players");
        for (int i = 0; i < players.length; ++i) {
            if (players[i].getToken() == i + 1) continue;
            throw new IllegalArgumentException(String.format("The 'players' array must be ordered by player tokens ascending, starting at token 1 and incrementing by 1 for each following player!. Player %s at index %s violates this rule!", players[i], i));
        }
    }

    private C4State(C4State source) {
        this.board = source.board.deepCopy();
        this.players = new IC4Player[source.players.length];
        this.currentPlayerIndex = source.currentPlayerIndex;
        for (int i = 0; i < this.players.length; ++i) {
            this.players[i] = source.players[i].deepCopy();
        }
    }

    public Map<String, IC4Player> getPlayers() {
        if (this.playerMap == null) {
            HashMap<String, IC4Player> localPlayerMap = new HashMap<String, IC4Player>(this.players.length);
            for (IC4Player player : this.players) {
                localPlayerMap.put(player.getName(), player);
            }
            this.playerMap = localPlayerMap;
        }
        return this.playerMap;
    }

    public Set<IC4Player> computeNextPlayers() {
        IC4Player currentPlayer = this.getCurrentPlayer();
        if (currentPlayer.getState().equals((Object)PlayerState.PLAYING)) {
            return Collections.singleton(currentPlayer);
        }
        return Collections.emptySet();
    }

    public void nextTurn() {
        this.currentPlayerIndex = (this.currentPlayerIndex + 1) % this.players.length;
    }

    public IC4State deepCopy() {
        return new C4State(this);
    }

    @Override
    public IC4Board getBoard() {
        return this.board;
    }

    @Override
    public IC4Player getCurrentPlayer() {
        return this.players[this.currentPlayerIndex];
    }

    @Override
    public void onMoveCompleted() {
        Optional<IC4Solution> solution = this.board.tryFindFirstSolution();
        if (solution.isPresent()) {
            Set<IC4Solution> solutions = this.board.findAllSolutions();
            this.gameOver(Optional.of(solutions));
        } else {
            boolean isFull = this.board.isFull();
            if (isFull) {
                this.gameOver(Optional.empty());
            }
        }
    }

    private void gameOver(Optional<Set<IC4Solution>> optionalSolutions) {
        if (optionalSolutions.isPresent()) {
            Set<IC4Solution> solutions = optionalSolutions.get();
            for (IC4Player player : this.players) {
                if (solutions.stream().anyMatch(sln -> sln.getOwner().equals(player))) {
                    player.setState(PlayerState.WON);
                    continue;
                }
                player.setState(PlayerState.LOST);
            }
        } else {
            for (IC4Player player : this.players) {
                player.setState(PlayerState.DRAW);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append("C4State [board=").append(this.board.toString()).append(", players=").append(Arrays.toString(this.players)).append(", currentPlayer=").append(this.players[this.currentPlayerIndex].toString()).append(']');
        return builder.toString();
    }
}

