package de.fhdw.gaming.ipspiel23.c4.domain.impl.validation;

/**
 * Represents the update context for a {@link C4BoardValidator}.
 * Validation state update context instances are consumed by the validator to update the validation state.
 */
public class C4BoardValidationStateUpdateContext {

    /**
     * The limits to update.
     */
    private final C4BoardLimits limits;

    /**
     * The value to update the limits with.
     */
    private int value;
    
    /**
     * Creates a new instance of {@link C4BoardValidationStateUpdateContext}.
     * 
     * @param limits The limits to update.
     * @param value The value to update the limits with.
     */
    C4BoardValidationStateUpdateContext(final C4BoardLimits limits, final int value) {
        this.limits = limits;
        this.value = value;
    }

    /**
     * Gets the limits to update.
     */
    public C4BoardLimits getState() {
        return limits;
    }

    /**
     * Gets the value to update the limits with.
     */
    public int getValue() {
        return value;
    }

    /**
     * Sets the value to update the limits with.
     * @param value the new value
     */
    void setValue(final int value) {
        this.value = value;
    }
}
