package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;

/**
 * Represents a position on the connect four board.
 */
public class C4Position implements IC4Position {

    /**
     * The zero-based row index of this position.
     */
    private final int row;

    /**
     * The zero-based column index of this position.
     */
    private final int column;
    
    /**
     * Creates a new instance of {@link C4Position}.
     * @param rowIndex The zero-based row index of this position.
     * @param columnIndex The zero-based column index of this position.
     */
    public C4Position(final int rowIndex, final int columnIndex) {
        this.row = rowIndex;
        this.column = columnIndex;
    }
    
    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj instanceof IC4Position) {
            final IC4Position other = (IC4Position) obj;
            return this.row == other.getRow() && this.column == other.getColumn();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 17 * 31;
        hash += this.row;
        hash = hash * 31 + this.column;
        return hash;
    }

    @Override
    public String toString() {
        return String.format("C4Position(row: %d, column: %d)", this.row, this.column);
    }
}
