/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.MoveChecker;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgGame;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgGameBuilder;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayerBuilder;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgState;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgStrategy;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl.FzgGameImpl;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl.FzgPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl.FzgStateImpl;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.Answer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.impl.AbstractAnswer;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

public class FzgGameBuilderImpl
implements FzgGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<FzgPlayer> firstPlayer = Optional.empty();
    private Optional<FzgStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<FzgPlayer> secondPlayer = Optional.empty();
    private Optional<FzgStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    @Override
    public FzgPlayerBuilder createPlayerBuilder() {
        return new FzgPlayerBuilderImpl();
    }

    public FzgGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public FzgGameBuilder addPlayer(FzgPlayer player, FzgStrategy strategy) throws GameException {
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are not allowed.", new Object[0]));
        }
        return this;
    }

    @Override
    public FzgGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public FzgGame build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("Freizeitgestaltung needs two players.");
        }
        FzgStateImpl initialState = new FzgStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, FzgStrategy> strategies = new LinkedHashMap<String, FzgStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new FzgGameImpl(id, initialState, strategies, this.maxComputationTimePerMove, (MoveChecker<FzgPlayer, FzgState, Answer>)((MoveChecker)AbstractAnswer.class::isInstance), this.observerFactoryProvider);
    }
}

