package de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain;

import java.util.Map;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.AnswerOptions;

/**
 * Builder to Create a Player.
 *
 */
public interface FzgPlayerBuilder {

    /**
     * Changes the name of a Player.
     * @param newName new name of the player.
     * @return {@code this}
     */
    FzgPlayerBuilder changeName(String newName);

    /**
     * Changes the possible Outcome of a Player.
     * First Key: Answer of first player, second key: Answer of second player.
     * Value outcome for the constellation of answers.
     * @param possibleOutcomes
     */
    FzgPlayerBuilder changePossibleOutcomes(Map<AnswerOptions, Map<AnswerOptions, Double>> possibleOutcomes);

    /**
     * Builds the player.
     * @return the player.
     * @throws GameException 
     */
    FzgPlayer build() throws GameException;
}
