/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl;

import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgState;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.AnswerOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FzgStateImpl
implements FzgState {
    private final FzgPlayer firstPlayer;
    private final FzgPlayer secondPlayer;

    public FzgStateImpl(FzgPlayer firstPlayer, FzgPlayer secondPlayer) {
        this.firstPlayer = firstPlayer;
        this.secondPlayer = secondPlayer;
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    FzgStateImpl(FzgStateImpl source) {
        this.firstPlayer = (FzgPlayer)source.firstPlayer.deepCopy();
        this.secondPlayer = (FzgPlayer)source.secondPlayer.deepCopy();
    }

    public Map<String, FzgPlayer> getPlayers() {
        HashMap<String, FzgPlayer> retVal = new HashMap<String, FzgPlayer>();
        retVal.put(this.firstPlayer.getName(), this.firstPlayer);
        retVal.put(this.secondPlayer.getName(), this.secondPlayer);
        return retVal;
    }

    public String toString() {
        return String.format("FzgState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FzgStateImpl) {
            FzgStateImpl other = (FzgStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    @Override
    public FzgPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public FzgPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public Set<FzgPlayer> computeNextPlayers() {
        HashSet<FzgPlayer> retVal = new HashSet<FzgPlayer>();
        if (this.firstPlayer.getAnswer().isEmpty()) {
            retVal.add(this.firstPlayer);
        }
        if (this.secondPlayer.getAnswer().isEmpty()) {
            retVal.add(this.secondPlayer);
        }
        return retVal;
    }

    public void nextTurn() {
        Set<FzgPlayer> playersWithoutMove = this.computeNextPlayers();
        if (playersWithoutMove.isEmpty()) {
            AnswerOptions answerOfFirstPlayer = this.firstPlayer.getAnswer().orElseThrow();
            AnswerOptions answerOfSecondPlayer = this.secondPlayer.getAnswer().orElseThrow();
            Double outcomeOfFirstPlayer = this.firstPlayer.getPossibleOutcomes().get((Object)answerOfFirstPlayer).get((Object)answerOfSecondPlayer);
            this.firstPlayer.setState(this.outcomeToState(outcomeOfFirstPlayer));
            this.firstPlayer.setOutcome(outcomeOfFirstPlayer);
            Double outcomeOfSecondPlayer = this.secondPlayer.getPossibleOutcomes().get((Object)answerOfFirstPlayer).get((Object)answerOfSecondPlayer);
            this.secondPlayer.setState(this.outcomeToState(outcomeOfSecondPlayer));
            this.secondPlayer.setOutcome(outcomeOfSecondPlayer);
        }
    }

    public FzgState deepCopy() {
        return new FzgStateImpl(this);
    }

    private PlayerState outcomeToState(Double outcome) {
        return outcome > 0.0 ? PlayerState.WON : PlayerState.DRAW;
    }
}

