package de.fhdw.gaming.ipspiel23.dilemma.moves;

import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;

/**
 * Allows to create Dilemma moves.
 */
public interface IDilemmaMoveFactory {

    /**
     * Creates the move to confess.
     */
    IDilemmaMove createDefectMove();
    
    /**
     * Creates the move to stay silent.
     */
    IDilemmaMove createCooperateMove();

    /**
     * Creates a move equivalent to the provided move.
     * @param move The move to mirror.
     */
    IDilemmaMove sameAs(IDilemmaMove move);

    /**
     * Creates a move opposite to the provided move.
     * @param move The move to create the opposite of.
     */
    IDilemmaMove oppositeOf(IDilemmaMove move);

    /**
     * Creates a move corresponding to the provided answer type.
     * @param answer The answer type to create the move for.
     */
    IDilemmaMove fromAnswer(DilemmaAnswerType answer);
}
