package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.defect;

import java.util.Optional;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaStrategy;

/**
 * Implements {@link IDilemmaStrategy} by always confessing.
 */
public class DilemmaDefectStrategy extends DilemmaStrategy {

    /**
     * Creates an {@link DilemmaDefectStrategy}.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    DilemmaDefectStrategy(final IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }
    
    @Override
    public Optional<IDilemmaMove> computeNextMove(final int gameId,
            final IDilemmaPlayer player,
            final IDilemmaState state) {
        return Optional.of(getMoveFactory().createDefectMove());
    }

    @Override
    public String toString() {
        return DilemmaDefectStrategy.class.getSimpleName();
    }

    @Override
    public boolean equals(final Object object) {
        if (object instanceof DilemmaDefectStrategy) {
            final DilemmaDefectStrategy aussagenStrategy = (DilemmaDefectStrategy) object;
            return this.toString().equals(aussagenStrategy.toString());
        } else {
            return false;
        }
    }
    
    @Override
    public int hashCode() {
        return super.hashCode() * this.toString().hashCode();
    }
}
