package de.fhdw.gaming.ipspiel23.dilemma.utils;

/**
 * A reference to a value.
 * <p>
 * Used to emulate pass-by-reference semantics in Java ({@code ref} and {@code out} parameters in C#) or to
 * explicitly indicate that a parameter is used to return a value.
 * <p>
 * @param <T> The type of the referenced value.
 */
public class ByRef<T> {

    /**
     * The referenced value.
     */
    private T value;

    /**
     * Creates a new instance of the {@link ByRef} class.
     * 
     * @param value The initial value of the reference.
     */
    ByRef(final T value) {
        this.value = value;
    }

    /**
     * Sets the value of the reference.
     * 
     * @param value The new value of the reference.
     */
    public void setValue(final T value) {
        this.value = value;
    }

    /**
     * Gets the value of the reference.
     * 
     * @return The value of the reference.
     */
    public T getValue() {
        return this.value;
    }
}