package de.fhdw.gaming.ipspiel23.dilemma.domain;

import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.memory.IMemoryState;

/**
 * Represents the state of a Dilemma game.
 */
public interface IDilemmaState extends IMemoryState<IDilemmaPlayer, IDilemmaState, DilemmaRoundData> {

    /**
     * Returns the first player.
     */
    IDilemmaPlayer getFirstPlayer();

    /**
     * Returns the second player.
     */
    IDilemmaPlayer getSecondPlayer();

    /**
     * Returns the opponent of the given player.
     * @param player The player to get the opponent for.
     * @return The opponent of the given player.
     */
    IDilemmaPlayer getOpponentOf(IDilemmaPlayer player);
}
