package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.pavlov;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;

/**
 * Cooperates if it and its opponent moved alike in previous move and defects if they moved differently.
 */
public class DilemmaPavlovStrategy extends DilemmaMemoryStrategy {

    /**
     * Creates a new instance of the {@link DilemmaPavlovStrategy} class using the given {@link IDilemmaMoveFactory}.
     *
     * @param moveFactory the move factory to use
     */
    protected DilemmaPavlovStrategy(final IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    @Override
    public Optional<IDilemmaMove> computeNextMove(final int gameId, final IDilemmaPlayer player, 
            final IDilemmaState state)
            throws GameException, InterruptedException {
        final IGameMemory<DilemmaRoundData> memory = getMemoryForPlayer(player, state);
        final IDilemmaMoveFactory moveFactory = getMoveFactory();
        // let's be nice on the first round ...
        if (memory.size() == 0) {
            return Optional.of(moveFactory.createCooperateMove());
        }
        final DilemmaRoundData previousRound = memory.getRound(0, true);
        // ... and cooperates if our opponent moved alike in previous move, otherwise defect if they moved differently.
        return Optional.of(
            previousRound.player1Data().answer().equals(previousRound.player2Data().answer())
                ? moveFactory.createCooperateMove()
                : moveFactory.createDefectMove());
    }

    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.unlimited();
    }
}
