/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel23-dilemma.
 *
 * Ipspiel23-dilemma is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel23-dilemma is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel23-dilemma. If not, see
 * <http://www.gnu.org/licenses/>.
 */

import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.cooperate.DilemmaCooperateStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.defect.DilemmaDefectStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.discriminating_altruist.DilemmaDiscriminatingAltruistStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.generous_tit_for_tat.DilemmaGenerousTitForTatStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.gradual_tit_for_tat.DilemmaGradualTitForTatStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.grim.DilemmaGrimStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.imperfect_tit_for_tat.DilemmaImperfectTitForTatStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.pavlov.DilemmaPavlovStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.probability.DilemmaProbabilityStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.random.DilemmaRandomStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.reactive.DilemmaReactiveStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.suspicious_tit_for_tat.DilemmaSuspiciousTitForTatStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.tit_for_tat.DilemmaTitForTatStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.tit_for_two_tats.DilemmaTitForTwoTatsStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.two_tits_for_tat.DilemmaTwoTitsforTatStrategyFactory;

open module de.fhdw.gaming.ipspiel23.dilemma {
    exports de.fhdw.gaming.ipspiel23.dilemma.domain;
    exports de.fhdw.gaming.ipspiel23.dilemma.moves;
    exports de.fhdw.gaming.ipspiel23.dilemma.strategy;
    
    requires transitive de.fhdw.gaming.core;
    requires transitive de.fhdw.gaming.ipspiel23.memory;

    uses de.fhdw.gaming.ipspiel23.dilemma.strategy.IDilemmaStrategyFactory;

    provides de.fhdw.gaming.ipspiel23.dilemma.strategy.IDilemmaStrategyFactory
    with DilemmaCooperateStrategyFactory,
         DilemmaDefectStrategyFactory,
         DilemmaTitForTatStrategyFactory,
         DilemmaImperfectTitForTatStrategyFactory,
         DilemmaPavlovStrategyFactory,
         DilemmaDiscriminatingAltruistStrategyFactory,
         DilemmaGenerousTitForTatStrategyFactory,
         DilemmaGradualTitForTatStrategyFactory,
         DilemmaGrimStrategyFactory,
         DilemmaProbabilityStrategyFactory,
         DilemmaRandomStrategyFactory,
         DilemmaReactiveStrategyFactory,
         DilemmaSuspiciousTitForTatStrategyFactory,
         DilemmaTitForTwoTatsStrategyFactory,
         DilemmaTwoTitsforTatStrategyFactory;
    
    provides de.fhdw.gaming.core.domain.GameBuilderFactory
        with de.fhdw.gaming.ipspiel23.dilemma.domain.internals.DilemmaGameBuilderFactory;
}
