package de.fhdw.gaming.ipspiel23.dilemma.domain;

import java.util.Map;

import de.fhdw.gaming.core.domain.GameException;

/**
 * A builder which allows to create a DilemmaPlayer.
 */
public interface IDilemmaPlayerBuilder {

    /**
     * Changes the name of the player.
     * <p>
     * There is no default.
     * </p>
     * 
     * @param newName The name of the player.
     * @return {@code this}
     */
    IDilemmaPlayerBuilder changeName(String newName);

    /**
     * Changes the possible outcomes of the player.
     * <p>
     * There is no default.
     *
     * @param possibleOutcomes The possible outcomes of the player. The key for the first-level map is the answer of the
     *                         first player, the key for the second-level map is the answer of the second player.
     */
    IDilemmaPlayerBuilder changePossibleOutcomes(
        Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> possibleOutcomes);

    /**
     * Builds the player.
     *
     * @return The Dilemma player.
     * @throws GameException if creating the player is not allowed by the rules of the game.
     */
    IDilemmaPlayer build() throws GameException;
}