/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.ssp.domain.impl;

import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel23.ssp.domain.impl.outcomes.SspAnswer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class SspPlayerImpl
extends AbstractPlayer<SspPlayer>
implements SspPlayer {
    private final Map<SspAnswer, Map<SspAnswer, Double>> possibleOutcomes;
    private Optional<SspAnswer> answer;

    SspPlayerImpl(String name, Map<SspAnswer, Map<SspAnswer, Double>> possibleOutcomes) {
        super(name);
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<SspAnswer, Map<SspAnswer, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
        this.answer = Optional.empty();
    }

    SspPlayerImpl(SspPlayer source) {
        super((Player)source);
        this.possibleOutcomes = source.getPossibleOutcomes();
        this.answer = source.getAnswer();
    }

    public String toString() {
        return String.format("SspPlayer[name=%s, state=%s, outcome=%s, answer=%s]", this.getName(), this.getState(), this.getOutcome(), this.answer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SspPlayerImpl) {
            SspPlayerImpl other = (SspPlayerImpl)obj;
            return super.equals(obj) && this.answer.equals(other.answer) && this.possibleOutcomes.equals(other.possibleOutcomes);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ Objects.hash(this.answer, this.possibleOutcomes);
    }

    @Override
    public Map<SspAnswer, Map<SspAnswer, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public Optional<SspAnswer> getAnswer() {
        return this.answer;
    }

    @Override
    public void setAnswer(SspAnswer newAnswer) {
        if (this.answer.isPresent()) {
            throw new IllegalStateException(String.format("Player %s tried to change her answer.", this.getName()));
        }
        this.answer = Optional.of(newAnswer);
    }

    @Override
    public SspPlayer deepCopy() {
        return new SspPlayerImpl(this);
    }
}

