/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel23-Ssp.
 *
 * Ipspiel23-Ssp is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel23-Ssp is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel23-Ssp. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel23.ssp.domain;

import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel23.ssp.domain.impl.outcomes.SspAnswer;

import java.util.Map;
import java.util.Optional;

/**
 * Provides a player interface for SSP-Game.
 *
 * @author DW
 *
 */
public interface SspPlayer extends Player<SspPlayer> {

    /**
     * Returns the possible outcomes of this player. The key for the first-level map is the answer of the first player,
     * the key for the second-level map is the answer of the second player.
     */
    Map<SspAnswer, Map<SspAnswer, Double>> getPossibleOutcomes();

    /**
     * Returns the answer of this player.
     */
    Optional<SspAnswer> getAnswer();

    /**
     * Sets the answer of this player.
     *
     * @param newAnswer The answer to set. {@code true} means "yes", {@code false} means "no"
     * @throws IllegalStateException if an answer has already been set.
     */
    void setAnswer(SspAnswer newAnswer);

    @Override
    SspPlayer deepCopy();
}
