package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;

/**
 * Abstract base class for Dilemma strategies.
 */
public abstract class DilemmaStrategy implements IDilemmaStrategy {

    /**
     * The factory for creating Dilemma moves.
     */
    private final IDilemmaMoveFactory moveFactory;

    /**
     * Creates a new Dilemma strategy.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    protected DilemmaStrategy(final IDilemmaMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    /**
     * Returns the factory for creating Dilemma moves.
     *
     * @return The factory for creating Dilemma moves.
     */
    protected final IDilemmaMoveFactory getMoveFactory() {
        return moveFactory;
    }
}
