package de.fhdw.gaming.ipspiel23.dilemma.domain;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;

/**
 * A builder which allows to create a Dilemma game.
 */
public interface IDilemmaGameBuilder extends GameBuilder {
    
    /**
     * The default outcome for Schweigen/Schweigen.
     */
    int DEFAULT_OUTCOME_COOPERATE_COOPERATE = -1;
    /**
     * The default outcome for Schweigen/Aussagen.
     */
    int DEFAULT_OUTCOME_COOPERATE_DEFECT = -10;
    /**
     * The default outcome for Aussagen/Schweigen.
     */
    int DEFAULT_OUTCOME_DEFECT_COOPERATE = 0;
    /**
     * The default outcome for Aussagen/Aussagen.
     */
    int DEFAULT_OUTCOME_DEFECT_DEFECT = -8;
    /**
     * The default computation time in seconds. 
     */
    int DEFAULT_COMPUTATION_TIME = 5;

    /**
     * Creates an {@link IDilemmaPlayerBuilder} which allows to create and add a player to the game together with her
     * strategy.
     */
    IDilemmaPlayerBuilder createPlayerBuilder();

    /**
     * Adds a player and her corresponding strategy.
     *
     * @param player   The player.
     * @param strategy The player's strategy.
     * @throws GameException if adding the player is not allowed by the rules of the game.
     */
    IDilemmaGameBuilder addPlayer(IDilemmaPlayer player, IDilemmaStrategy strategy) throws GameException;

    /**
     * Changes the {@link ObserverFactoryProvider}.
     *
     * @param newObserverFactoryProvider The new {@link ObserverFactoryProvider}.
     * @return {@code this}
     */
    IDilemmaGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider);

    @Override 
    IDilemmaGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove);

    @Override
    IDilemmaGame build(int id) throws GameException, InterruptedException;
}
