package de.fhdw.gaming.ipspiel24.fg.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGState;
import de.fhdw.gaming.ipspiel24.fg.domain.FGStrategy;
import de.fhdw.gaming.ipspiel24.fg.moves.FGMove;
import de.fhdw.gaming.ipspiel24.fg.moves.factory.FGMoveFactory;

/**
 * Cinema Strategy.
 */
public class FGCinemaStrategy implements FGStrategy {

    /**
     * The factory for creating FG moves.
     */
    private final FGMoveFactory moveFactory;

    /**
     * Creates an {@link FGSayYesStrategy}.
     *
     * @param moveFactory The factory for creating FG moves.
     */
    FGCinemaStrategy(final FGMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<FGMove> computeNextMove(
            final int gameId,
            final FGPlayer player,
            final FGState state,
            final long maxComputationTimePerMove) {
        return Optional.of(this.moveFactory.createCinemaMove());
    }

    @Override
    public String toString() {
        return FGCinemaStrategy.class.getSimpleName();
    }
}
