
package de.fhdw.gaming.ipspiel24.fg.domain.impl;

import java.util.Optional;

import de.fhdw.gaming.ipspiel24.fg.domain.FGMoveGenerator;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGState;
import de.fhdw.gaming.ipspiel24.fg.moves.FGMove;
import de.fhdw.gaming.ipspiel24.fg.moves.factory.FGMoveFactory;
import de.fhdw.gaming.ipspiel24.fg.moves.impl.FGDefaultMoveFactory;

/**
 * Implements the {@link FGMoveGenerator} interface.
 */
final class FGMoveGeneratorImpl implements FGMoveGenerator {

    /**
     * The move factory.
     */
    private final FGMoveFactory moveFactory = new FGDefaultMoveFactory();

    @Override
    public Optional<FGMove> generate(final FGPlayer player, final FGState state) {
        // choose "no" to punish lame strategies
        return Optional.of(this.moveFactory.createFootballMove());
    }
}
