package de.fhdw.gaming.ipspiel24.fg.domain;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.Player;

/**
 * Represents a Freizeitgetstaltung player.
 */
public interface FGPlayer extends Player<FGPlayer> {
    /**
     * Returns the possible outcomes of this player. The key for the first-level map is the answer of the first player,
     * the key for the second-level map is the answer of the second player.
     */
    Map<FGActivity, Map<FGActivity, Double>> getPossibleOutcomes();

    /**
     * Returns the answer of this player.
     */
    Optional<FGActivity> getAnswer();

    /**
     * Sets the answer of this player.
     *
     * @param newAnswer The answer to set. {@code true} means "cinema", {@code false} means "football"
     * @throws IllegalStateException if an answer has already been set.
     */
    void setAnswer(FGActivity newAnswer);
    
    @Override
    FGPlayer deepCopy();

}
