/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-tictactoe-strategy-random.
 *
 * ipspiel24-tictactoe-strategy-random is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * ipspiel24-tictactoe-strategy-random is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * ipspiel24-tictactoe-strategy-random. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.tictactoe.strategy.random;

import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeStrategy;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.factory.TicTacToeStrategyFactory;
import de.fhdw.gaming.ipspiel24.tictactoe.core.moves.factory.TicTacToeMoveFactory;

/**
 * Implements {@link TicTacToeStrategyFactory}.
 */
public final class TicTacToeRandomMoveStrategyFactory implements TicTacToeStrategyFactory {

    @Override
    public TicTacToeStrategy create(final TicTacToeMoveFactory moveFactory) {
        return new TicTacToeRandomMoveStrategy(moveFactory);
    }
}
