/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.ssp.domain.impl;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.MoveGenerator;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspGameBuilder;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspPlayerBuilder;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspState;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspStrategy;
import de.fhdw.gaming.ipspiel24.ssp.domain.impl.SspMoveGeneratorImpl;
import de.fhdw.gaming.ipspiel24.ssp.domain.impl.SspPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel24.ssp.domain.impl.SspStateImpl;
import de.fhdw.gaming.ipspiel24.ssp.moves.SspMove;
import de.fhdw.gaming.ipspiel24.ssp.moves.impl.AbstractSspMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

final class SspGameBuilderImpl
implements SspGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<SspPlayer> firstPlayer = Optional.empty();
    private Optional<SspStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<SspPlayer> secondPlayer = Optional.empty();
    private Optional<SspStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    SspGameBuilderImpl() {
    }

    @Override
    public SspPlayerBuilder createPlayerBuilder() {
        return new SspPlayerBuilderImpl();
    }

    @Override
    public SspGameBuilder addPlayer(SspPlayer player, SspStrategy strategy) throws GameException {
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public SspGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public SspGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public Game<SspPlayer, SspState, SspMove, SspStrategy> build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A Ssp game needs two players.");
        }
        SspStateImpl initialState = new SspStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, SspStrategy> strategies = new LinkedHashMap<String, SspStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new DefaultGame(id, (State)initialState, strategies, (long)this.maxComputationTimePerMove, AbstractSspMove.class::isInstance, (MoveGenerator)new SspMoveGeneratorImpl(), this.observerFactoryProvider);
    }
}

