/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.minimax;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel24.minimax.MinimaxStrategy;
import java.util.List;

public class Minimax<P extends Player<P>, S extends State<P, S>, M extends Move<P, S>> {
    private final int maxDepth;
    private final MinimaxStrategy<P, S, M> strategy;
    private final P opponent;
    private final int endScore = 10000;

    public Minimax(MinimaxStrategy<P, S, M> strategy, int maxDepth, P opponent) {
        this.strategy = strategy;
        this.maxDepth = maxDepth;
        this.opponent = opponent;
    }

    public M getBestMove(S state, P player) throws GameException {
        List<M> possibleMoves = this.strategy.getPossibleMoves(state);
        if (possibleMoves.isEmpty()) {
            return null;
        }
        int bestScore = -2147483647;
        Move bestMove = null;
        for (Move move : possibleMoves) {
            State stateCopy = state.deepCopy();
            move.applyTo(stateCopy, player);
            stateCopy.nextTurn();
            int score = -this.negamax(stateCopy, player, 0, -2147483647, Integer.MAX_VALUE, false);
            if (score <= bestScore) continue;
            bestScore = score;
            bestMove = move;
        }
        return (M)bestMove;
    }

    private int negamax(S state, P player, int depth, int alpha, int beta, boolean isMaximising) throws GameException {
        int newAlpha = alpha;
        int newBeta = beta;
        int evaluation = this.strategy.evaluate(state, player, depth);
        List<M> possibleMoves = this.strategy.getPossibleMoves(state);
        if (depth == this.maxDepth || possibleMoves.isEmpty() || evaluation > this.endScore) {
            return evaluation * (isMaximising ? 1 : -1);
        }
        int bestValue = -2147483647;
        for (Move move : possibleMoves) {
            State stateCopy = state.deepCopy();
            move.applyTo(stateCopy, isMaximising ? player : this.opponent);
            stateCopy.nextTurn();
            int value = -this.negamax(stateCopy, player, depth + 1, -newBeta, -newAlpha, !isMaximising);
            if ((newAlpha = Math.max(newAlpha, bestValue = Math.max(bestValue, value))) < newBeta) continue;
            break;
        }
        return bestValue;
    }
}

