/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.demo.domain.impl;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.MoveGenerator;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel24.demo.domain.DemoGameBuilder;
import de.fhdw.gaming.ipspiel24.demo.domain.DemoPlayer;
import de.fhdw.gaming.ipspiel24.demo.domain.DemoPlayerBuilder;
import de.fhdw.gaming.ipspiel24.demo.domain.DemoState;
import de.fhdw.gaming.ipspiel24.demo.domain.DemoStrategy;
import de.fhdw.gaming.ipspiel24.demo.domain.impl.DemoMoveGeneratorImpl;
import de.fhdw.gaming.ipspiel24.demo.domain.impl.DemoPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel24.demo.domain.impl.DemoStateImpl;
import de.fhdw.gaming.ipspiel24.demo.moves.DemoMove;
import de.fhdw.gaming.ipspiel24.demo.moves.impl.AbstractDemoMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

final class DemoGameBuilderImpl
implements DemoGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<DemoPlayer> firstPlayer = Optional.empty();
    private Optional<DemoStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<DemoPlayer> secondPlayer = Optional.empty();
    private Optional<DemoStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    DemoGameBuilderImpl() {
    }

    @Override
    public DemoPlayerBuilder createPlayerBuilder() {
        return new DemoPlayerBuilderImpl();
    }

    @Override
    public DemoGameBuilder addPlayer(DemoPlayer player, DemoStrategy strategy) throws GameException {
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public DemoGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public DemoGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public Game<DemoPlayer, DemoState, DemoMove, DemoStrategy> build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A Demo game needs two players.");
        }
        DemoStateImpl initialState = new DemoStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, DemoStrategy> strategies = new LinkedHashMap<String, DemoStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new DefaultGame(id, (State)initialState, strategies, (long)this.maxComputationTimePerMove, AbstractDemoMove.class::isInstance, (MoveGenerator)new DemoMoveGeneratorImpl(), this.observerFactoryProvider);
    }
}

