
package de.fhdw.gaming.ipspiel24.fg.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGState;
import de.fhdw.gaming.ipspiel24.fg.domain.FGStrategy;
import de.fhdw.gaming.ipspiel24.fg.moves.FGMove;
import de.fhdw.gaming.ipspiel24.fg.moves.factory.FGMoveFactory;

/**
 * Implements {@link FGStrategy} by always saying "no".
 */
public final class FGFootballStrategy implements FGStrategy {

    /**
     * The factory for creating FG moves.
     */
    private final FGMoveFactory moveFactory;

    /**
     * Creates an {@link FGFootballStrategy}.
     *
     * @param moveFactory The factory for creating FG moves.
     */
    FGFootballStrategy(final FGMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<FGMove> computeNextMove(
            final int gameId,
            final FGPlayer player,
            final FGState state,
            final long maxComputationTimePerMove) {
        return Optional.of(this.moveFactory.createFootballMove());
    }

    @Override
    public String toString() {
        return FGFootballStrategy.class.getSimpleName();
    }
}
