/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-GD.
 *
 * ipspiel24-GD is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * ipspiel24-GD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel24-GD. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.GefangenenDilemma.domain.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * Implements {@link GDStrategyFactoryProvider} by using the {@link ServiceLoader}.
 */
public final class GDDefaultStrategyFactoryProvider implements GDStrategyFactoryProvider {

    @Override
    public List<GDStrategyFactory> getStrategyFactories() {
        final ServiceLoader<
                GDStrategyFactory> services = ServiceLoader.load(GDStrategyFactory.class);
        final List<GDStrategyFactory> list = new ArrayList<>();
        services.iterator().forEachRemaining(list::add);
        return list;
    }
}
