package de.fhdw.gaming.ipspiel24.fg.strategy;

import java.security.SecureRandom;
import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGState;
import de.fhdw.gaming.ipspiel24.fg.domain.FGStrategy;
import de.fhdw.gaming.ipspiel24.fg.moves.FGMove;
import de.fhdw.gaming.ipspiel24.fg.moves.factory.FGMoveFactory;

/**
 * Strategy to pick Random Move.
 */
public class FGmixedMoveStrategy implements FGStrategy {
    /**
     * MoveFactory.
     */
    private final FGMoveFactory moveFactory;
    /**
     * New SecureRandom to generate Random Move.
     */
    private final SecureRandom random;
    /**
     * Creates an {@link FGFootballStrategy}.
     *
     * @param moveFactory The factory for creating FG moves.
     */
    FGmixedMoveStrategy(final FGMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
        this.random = new SecureRandom();
    }
    
    @Override
    public Optional<FGMove> computeNextMove(final int gameId, final FGPlayer player,
            final FGState state, final long maxComputationTimePerMove)
            throws GameException, InterruptedException {
        final double rand = random.nextInt(3);
        if (state.getFirstPlayer().equals(player)) {
            if (rand < 2) {
                return Optional.of(this.moveFactory.createFootballMove());
            } else {
                return Optional.of(this.moveFactory.createCinemaMove()); 
            }
        } else {
            if (rand >= 2) {
                return Optional.of(this.moveFactory.createFootballMove());
            } else {
                return Optional.of(this.moveFactory.createCinemaMove()); 
            }
        }
    }

    
    @Override
    public String toString() {
        return FGmixedMoveStrategy.class.getSimpleName();
    }
}
