/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-Ssp.
 *
 * Ipspiel24-Ssp is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel24-Ssp is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel24-Ssp. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.ssp.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A Ssp {@link GameBuilderFactory} which allows to create a Ssp game builder.
 */
public interface SspGameBuilderFactory extends GameBuilderFactory {

    /**
     * Player's outcome on rock/rock.
     */
    String PARAM_PLAYER_OUTCOME_ON_ROCK_ROCK = "playerOutcomeOnRockRock";

    /**
     * Player's outcome on rock/scissors.
     */
    String PARAM_PLAYER_OUTCOME_ON_ROCK_SCISSORS = "playerOutcomeOnRockScissors";
    
    /**
     * Player's outcome on rock/paper.
     */
    String PARAM_PLAYER_OUTCOME_ON_ROCK_PAPER = "playerOutcomeOnRockPaper";


    /**
     * Player's outcome on paper/rock.
     */
    String PARAM_PLAYER_OUTCOME_ON_PAPER_ROCK = "playerOutcomeOnPaperRock";

    /**
     * Player's outcome on paper/scissors.
     */
    String PARAM_PLAYER_OUTCOME_ON_PAPER_SCISSORS = "playerOutcomeOnPaperScissors";
    
    /**
     * Player's outcome on paper/paper.
     */
    String PARAM_PLAYER_OUTCOME_ON_PAPER_PAPER = "playerOutcomeOnPaperPaper";


    /**
     * Player's outcome on scissors/rock.
     */
    String PARAM_PLAYER_OUTCOME_ON_SCISSORS_ROCK = "playerOutcomeOnScissorsRock";

    /**
     * Player's outcome on scissors/scissors.
     */
    String PARAM_PLAYER_OUTCOME_ON_SC_SC = "playerOutcomeOnScissorsScissors";
    
    /**
     * Player's outcome on scissors/paper.
     */
    String PARAM_PLAYER_OUTCOME_ON_SCISSORS_PAPER = "playerOutcomeOnScissorsPaper";

    @Override
    SspGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
