package de.fhdw.gaming.ipspiel24.fg.domain;

import java.util.List;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.ipspiel24.fg.moves.FGMove;

/**
 * A builder which allows to create a Freizeitgestaltung game.
 */
public interface FGGameBuilder extends GameBuilder {

    /**
     * Creates an{@link FGPlayerBuilder} which allows to create and add a player to the game together with her
     * strategy.
     *
     */
    FGPlayerBuilder createPlayerBuilder();

    /**
     * Adds a player and her corresponding strategy.
     *
     * @param player   The player.
     * @param strategy The player's strategy.
     * @throws GameException if adding the player is not allowed by the rules of the game.
     */
    FGGameBuilder addPlayer(FGPlayer player, FGStrategy strategy) throws GameException;

    @Override
    FGGameBuilder addObservers(List<Observer> newObservers);

    @Override
    Game<FGPlayer, FGState, FGMove, FGStrategy> build(int id) throws GameException, InterruptedException;

}
