/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.VierConnects.gui.impl;

import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsFieldState;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

final class VierConnectsFieldView
extends Region {
    private VierConnectsFieldState fieldState;
    private final Canvas canvas;
    private final ObjectProperty<Duration> moveDuration;
    private boolean highlighted;

    VierConnectsFieldView(VierConnectsFieldState fieldState) {
        this.fieldState = fieldState;
        this.moveDuration = new SimpleObjectProperty((Object)Duration.millis((double)500.0));
        this.highlighted = false;
        this.canvas = new Canvas(){

            public boolean isResizable() {
                return true;
            }

            public double prefWidth(double height) {
                return 0.0;
            }

            public double prefHeight(double width) {
                return 0.0;
            }

            public double maxWidth(double height) {
                return Double.POSITIVE_INFINITY;
            }

            public double maxHeight(double width) {
                return Double.POSITIVE_INFINITY;
            }
        };
        this.canvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.canvas);
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.draw());
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.draw());
        this.setMinSize(50.0, 50.0);
        this.setMaxSize(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    ObjectProperty<Duration> moveDurationProperty() {
        return this.moveDuration;
    }

    void setFieldState(VierConnectsFieldState fieldState) {
        this.fieldState = fieldState;
        this.draw();
    }

    void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
        this.draw();
    }

    private void draw() {
        double height = this.getHeight();
        double width = this.getWidth();
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.setFill((Paint)(this.highlighted ? Color.BLUE : Color.DARKBLUE));
        gc.fillRect(0.0, 0.0, width, height);
        gc.setFill((Paint)Color.BLACK);
        gc.beginPath();
        gc.moveTo(0.0, 0.0);
        gc.lineTo(width, 0.0);
        gc.lineTo(width, height);
        gc.lineTo(0.0, height);
        gc.lineTo(0.0, 0.0);
        gc.closePath();
        double marginheight = height * 0.1;
        double marginwidth = width * 0.1;
        gc.setFill((Paint)Color.WHITE);
        gc.fillOval(marginwidth, marginheight, width - 2.0 * marginwidth, height - 2.0 * marginheight);
        gc.stroke();
        switch (this.fieldState) {
            case EMPTY: {
                break;
            }
            case CROSS: {
                gc.setFill((Paint)Color.RED);
                gc.fillOval(marginwidth, marginheight, width - 2.0 * marginwidth, height - 2.0 * marginheight);
                break;
            }
            case NOUGHT: {
                gc.setFill((Paint)Color.YELLOW);
                gc.fillOval(marginwidth, marginheight, width - 2.0 * marginwidth, height - 2.0 * marginheight);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown Vier Connects field state '%s'.", this.fieldState));
            }
        }
    }
}

