/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.fg.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel24.fg.domain.FGActivity;
import de.fhdw.gaming.ipspiel24.fg.domain.FGGameBuilder;
import de.fhdw.gaming.ipspiel24.fg.domain.FGGameBuilderFactory;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayerBuilder;
import de.fhdw.gaming.ipspiel24.fg.domain.FGStrategy;
import de.fhdw.gaming.ipspiel24.fg.domain.factory.FGDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel24.fg.domain.factory.FGStrategyFactory;
import de.fhdw.gaming.ipspiel24.fg.domain.factory.FGStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel24.fg.domain.impl.FGGameBuilderImpl;
import de.fhdw.gaming.ipspiel24.fg.moves.impl.FGDefaultMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class FGGameBuilderFactoryImpl
implements FGGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<FGStrategy> strategies;

    public FGGameBuilderFactoryImpl() {
        this(new FGDefaultStrategyFactoryProvider());
    }

    FGGameBuilderFactoryImpl(FGStrategyFactoryProvider strategyFactoryProvider) {
        FGDefaultMoveFactory moveFactory = new FGDefaultMoveFactory();
        List<FGStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<FGStrategy>();
        for (FGStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "FG";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<FGStrategy>(this.strategies);
    }

    @Override
    public FGGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            FGGameBuilderImpl gameBuilder = new FGGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1", true);
            FGPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            FGStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2", false);
            FGPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            FGStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating FG game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title, boolean isFirstPlayer) throws GameException, InputProviderException {
        inputProvider.needString("playerName", isFirstPlayer ? "Klaus" : "Gabi", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnFootballFootball", "Player's outcome on Football/Football", isFirstPlayer ? Optional.of(2) : Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnFootballCinema", "Player's outcome on Football/Cinema", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnCinemaFootball", "Player's outcome on Cinema/Football", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnCinemaCinema", "Player's outcome on Cinema/Cinema", isFirstPlayer ? Optional.of(1) : Optional.of(2), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private FGPlayer createPlayer(FGPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<FGActivity, Map<FGActivity, Double>> possibleOutcomes = new LinkedHashMap<FGActivity, Map<FGActivity, Double>>();
        LinkedHashMap<FGActivity, Double> possibleOutcomesNo = new LinkedHashMap<FGActivity, Double>();
        possibleOutcomesNo.put(FGActivity.FOOTBALL, Double.valueOf(((Integer)playerData.get("playerOutcomeOnFootballFootball")).intValue()));
        possibleOutcomesNo.put(FGActivity.CINEMA, Double.valueOf(((Integer)playerData.get("playerOutcomeOnFootballCinema")).intValue()));
        possibleOutcomes.put(FGActivity.FOOTBALL, possibleOutcomesNo);
        LinkedHashMap<FGActivity, Double> possibleOutcomesYes = new LinkedHashMap<FGActivity, Double>();
        possibleOutcomesYes.put(FGActivity.FOOTBALL, Double.valueOf(((Integer)playerData.get("playerOutcomeOnCinemaFootball")).intValue()));
        possibleOutcomesYes.put(FGActivity.CINEMA, Double.valueOf(((Integer)playerData.get("playerOutcomeOnCinemaCinema")).intValue()));
        possibleOutcomes.put(FGActivity.CINEMA, possibleOutcomesYes);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private FGStrategy getStrategy(Map<String, Object> playerData) {
        return (FGStrategy)playerData.get("playerStrategy");
    }
}

